//
//  PhotoUpload.h
//  Composr Mobile SDK
//
//  Created by Aaswini on 02/09/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
import UIKit
class PhotoUpload: UIImageView, UIActionSheetDelegate, UIImagePickerControllerDelegate, UINavigationControllerDelegate {


    override init(frame: CGRect) {
        super.init(frame: frame)
        
        self.initialize()
    
    }

    func initialize() {
        var singleTap = UITapGestureRecognizer(target: self, action: self.didTap)
        self.addGestureRecognizer(singleTap)
        self.userInteractionEnabled = true
    }

    func didTap(sender: UITapGestureRecognizer) {
        UIActionSheet(title: "", delegate: self, cancelButtonTitle: "Cancel", destructiveButtonTitle: "").showInView(self.superview!)
    }

    func actionSheet(actionSheet: UIActionSheet, clickedButtonAtIndex buttonIndex: Int) {
        print("clicked action sheet button - \(buttonIndex)")
        switch buttonIndex {
            case 0:
                self.showPickerWithCamera(false)
            case 1:
                if !UIImagePickerController.isSourceTypeAvailable(.Camera) {
                    UIAlertView(title: "Oops !!", message: "Your device doesn't have a camera.", delegate: nil, cancelButtonTitle: "OK").show()
                }
                else {
                    self.showPickerWithCamera(true)
                }
            default:
                break
        }

    }

    func showPickerWithCamera(useCamera: Bool) {
        var picker = UIImagePickerController()
        picker.delegate = self
        if useCamera {
            picker.sourceType = .Camera
            picker.showsCameraControls = true
        }
        else {
            picker.sourceType = .SavedPhotosAlbum
        }
        picker.modalTransitionStyle = .FlipHorizontal
        self.viewController().presentViewController(picker, animated: true, completion: { _ in })
    }

    func imagePickerController(picker: UIImagePickerController, didFinishPickingMediaWithInfo info: [NSObject : AnyObject]) {
        self.image = (info[UIImagePickerControllerOriginalImage] as! String)
        picker.dismissViewControllerAnimated(true, completion: { _ in })
    }

    func imagePickerControllerDidCancel(picker: UIImagePickerController) {
        picker.dismissViewControllerAnimated(true, completion: { _ in })
    }

    func viewController() -> UIViewController {
        var next = self.superview!
        while next {
            var nextResponder = next.nextResponder()!
            if (nextResponder is UIViewController) {
                return (nextResponder as! UIViewController)
            }
            next = next.superview!
        }
        return nil
    }
}